from sqlalchemy import Column, Integer, String, Date
from database import Base

class Admin(Base):
    __tablename__ = "admins"
    id = Column(Integer, primary_key=True, index=True)
    email = Column(String(255), unique=True, index=True, nullable=False)
    password_hash = Column(String(255), nullable=False)

class Subscription(Base):
    __tablename__ = "subscriptions"
    id = Column(Integer, primary_key=True, index=True)
    account_type = Column(String(50), default="TUKI")
    email = Column(String(255), unique=True, index=True, nullable=False)
    password_hash = Column(String(255), nullable=False)   # para login del usuario
    pw_note = Column(String(64), nullable=True)           # SOLO para notificación (opcional)
    profile = Column(Integer, default=1)
    pin = Column(String(10), nullable=True)
    expiry_date = Column(Date, nullable=True)
    phone = Column(String(20), nullable=True)             # número WhatsApp (con o sin +51)