from sqlalchemy import create_engine
from sqlalchemy.orm import sessionmaker, declarative_base

# Para pruebas locales (rápido). Luego cambiaremos a MySQL en cPanel.
SQLALCHEMY_DATABASE_URL = "sqlite:///./tuki.db"

engine = create_engine(
    SQLALCHEMY_DATABASE_URL, connect_args={"check_same_thread": False}
)
SessionLocal = sessionmaker(autocommit=False, autoflush=False, bind=engine)

Base = declarative_base()

def get_db():
    db = SessionLocal()
    try:
        yield db
    finally:
        db.close()
